#ifndef __ACEDRMUI_H__
#define __ACEDRMUI_H__

#include "SimpleDialog.h"

#include "SexyAppFramework/EditListener.h"

namespace Sexy
{

class EditWidget;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
enum
{
	AceDRM_PurchaseDialog = 1000,
	AceDRM_ActivateDialog = 1001,
	AceDRM_MiscDialog = 1002,
	AceDRM_Purchase = 1,
	AceDRM_Activate = 2
};


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
class AceDRMPurchaseDialog : public SimpleDialog
{
protected:
	DialogButton *mPurchaseButton;
	DialogButton *mActivateButton;

public:
	static int mButtonGap;

public:
	AceDRMPurchaseDialog(const std::string &theName = "", const std::string &theLines = "", const std::string &theCancel = "");
	virtual ~AceDRMPurchaseDialog();

	virtual int GetPreferredHeight(int theWidth);
	virtual void Resize(int x, int y, int width, int height);
	virtual void ButtonDepress(int theId);
};


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
class AceDRMActivateDialog : public SimpleDialog, public EditListener
{
protected:
	EditWidget *mEdit;

public:
	AceDRMActivateDialog(const std::string &theName);
	virtual ~AceDRMActivateDialog();

	virtual int GetPreferredHeight(int theWidth);
	virtual void AddedToManager(WidgetManager *theManager);
	virtual void Resize(int x, int y, int width, int height);
	virtual void ButtonDepress(int theId);
	virtual void EditWidgetText(int theId, const std::string& theString);
	void SetEditText(const std::string &theText);
	const std::string GetEditText();
};


}

#endif